define([
    'underscore',
    'backbone',
    'marionette',
    'User',
    'text!modules/page/footer/footer.html',
    'json!versionInfoJson',
], function(_, Backbone, Marionette, User, footerTemplate, version) {
    'use strict';

    return Backbone.Marionette.View.extend({
        className: 'page-footer',
        template: _.template(footerTemplate),
        model: User,
        modelEvents: {change: 'render'},
        initialize: function() {
            this.app = {
                title: version.title,
                version: version.version,
            };
        },
        templateContext: function() {
            var self = this;
            return {
                showLoggedInUser: function() {
                    return self.model.has('id');
                },
                getAppTitle: function() {
                    return self.app.title;
                },
                getVersion: function() {
                    return self.app.version;
                },
            };
        },
    });
});

